class GameSprite
  @@VALID_DIRECTIONS = [:north, :west, :south, :east].freeze
  def initialize(args, params)
    @position = {x: 0, y: 0}
    @size = {w: 0, h: 0}
    @path = ""
  end
  def primitive_marker
    :sprite
  end
  def path
    @path
  end

  def collides_with_walls
    true
  end

  def x
    @position.x
  end
  def y
    @position.y
  end
  def x=(value)
    @position.x = value
  end
  def y=(value)
    @position.y = value
  end
  def w
    @size.w
  end
  def h
    @size.h
  end

  
  def r
    255
  end
  def g
    255
  end
  def b
    255
  end
  def a
    255
  end
  
  def angle
    0
  end
  def angle_anchor_x
    0
  end
  def angle_anchor_y
    0
  end

  def flip_vertically
    false
  end
  def flip_horizontally
    false
  end

  def tile_x
    0
  end
  def tile_y
    0
  end
  def tile_w
    -1
  end
  def tile_h
    -1
  end

  def source_x
    0
  end
  def source_y
    0
  end
  def source_w
    -1
  end
  def source_h
    -1
  end

  def blendmode_enum
    1
  end

  def x2
    nil
  end
  def y2
    nil
  end
  def x3
    nil
  end
  def y3
    nil
  end

  def source_x2
    nil
  end
  def source_y2
    nil
  end
  def source_x3
    nil
  end
  def source_y3
    nil
  end


  def opposide_direction(direction)
    case direction
    when :north
      :south
    when :south
      :north
    when :east
      :west
    when :west
      :east
    end
  end

  def point_inside_rect?(rect)
    if @position.x >= rect.x && @position.y >= rect.y
      if @position.x <= (rect.x + rect.w) && @position.y <= (rect.y + rect.h)
        return true
      end
    end
    return false
  end

end